function [BCI,mean_BG,std_BG,n,stdev,X_Bfit]=Baseline_Fitting_Light(time_length,data,step_size,popFac,BOP)
%EO: Extended Options
%BOP: Baseline Options
%BOP =1:  The mean of baseline
%BOP =2:  A linear fit to the baseline
%BOP=3: Smoothdata function with Gaussian Option
%BOP=4:  Sequal combination of BOP3 and BOP4
%Data manipulation and establishment of threshol based data
X=[time_length data];
stdev=std(data);

%Secondary baseline construction based on BOP (baseline options)
if BOP==1 %baseline is the mean of filtered_I
    clear BG_array_appended X_Bfit
    mean_I=mean(data);
    BG=repmat(mean_I,size(data,1),1);%background signal
    BCI=(data-BG);%Background Corrected Current Signal
    mean_BG=mean(BCI);
    std_BG=std(BCI);
    
    X_Bfit=[time_length data BG];%has same dimentions as X
    n=0;
end

if BOP==2 %baseline isa linear fit to the filtered_I
    clear BG_array_appended X_Bfit
    p=polyfit(time_length,data,1);
    m=p(1);
    c=p(2);
    BG=(time_length*m)+c;%background signal
    BCI=(data-BG);%Background Corrected Current Signal
    mean_BG=mean(BCI);
    std_BG=std(BCI);
    
    X_Bfit=[time_length data BG];%has same dimentions as X
    n=0;
end

if BOP==3 || BOP==4%secondary Gaussian based baseline construction smoothdata function
clear X_Bfit BFit_Smooth
gauss_step_size=step_size*100;
BFit = smoothdata(data,'gaussian',gauss_step_size);%Background
BCI=(data-BFit);%Background Corrected Current Signal
mean_BG=mean(BCI);
std_BG=std(BCI);
X_Bfit=[time_length data BFit];%has same dimentions as X

n=0.1;%starting stdev for the next step
population_n=sum((data<(BFit+(n*stdev))));
total_population=size(data,1);
while population_n<popFac*total_population
    n=n+0.1;
    population_n=sum((data<(BFit+(n*stdev))));
end

%Only needed for the BOP= 4 case
BFit_Smooth=BFit; 
thresh_indexes2=(data>(BFit-(n*stdev)));
filtered_I_SBF=data(thresh_indexes2==1);%SBF=Smooth Baseline Fit
filtered_t_SBF=time_length(thresh_indexes2==1);%SBF=Smooth Baseline Fit
%X_filtered_SBF=[filtered_t_SBF filtered_I_SBF];%SBF=Smooth Baseline Fit
end %End of BOP =3

if BOP==4

filtered_I=filtered_I_SBF;
filtered_t=filtered_t_SBF;

YB=msbackadj(filtered_t,filtered_I,'StepSize',step_size);%background substracted signal
mean_YB=mean(YB);%mean of background substracted signal
BG=filtered_I-YB;%background signal
BG_array=[filtered_t BG];%background array [t I]

%this loop finds the closet baseline value for presumable events and assigns that baseline value to the event indexes
clear BG_array_appended BG_new_msbackadj X_Bfit
rejected_indexes=thresh_indexes2==0;

if sum(rejected_indexes)>0
rc=X(rejected_indexes,:);%rejected cases
It_fill=zeros(size(rc,1),2);
for j=1:size(rc,1)
    rct=rc(j,1);%rejected time value from threshold
    [~,idx]=min(abs(filtered_t-rct));
    It_fill(j,:)=[rct BG(idx)];
end
BG_array_appended=sortrows([BG_array;It_fill],1);%sorts based on column 1
BCI=(data-BG_array_appended(:,2))-mean_YB;%Background Corrected Current Signal
BG_new_msbackadj=[BG;It_fill(:,2)];%Background array with appended values
X_Bfit=[time_length data BFit_Smooth BG_new_msbackadj];%has same dimentions as X 

else
%this is when there are no pressumable events
BG_array_appended=BG_array;
BCI=(data-BG_array_appended(:,2))-mean_YB;%Background Corrected Current Signal
X_Bfit=[BG_array(:,1) BG_array(:,2) BFit_Smooth BG];

end
mean_BG=mean((filtered_I-BG_array(:,2))-mean_YB);
std_BG=std((filtered_I-BG_array(:,2))-mean_YB);
end

end